; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back Original (Copy Protected) - bob-load.prg
; -------------------------------------------------------------------------------------------------------------- ;
; For a very nice explanation of a fast loader routine see article:
;   --> "A 256 Byte Autostart Fast Loader for the Commodore 64" at: http://www.pagetable.com/?p=568
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $0845
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc                    ; C64 System Includes

C64CIA2                 include c64_cia2.asm              ; Complex Interface Adapter (CIA) #2 Registers  $dd00-$dd0f
C64VicII                include c64_vic.asm               ; Video Interface Chip (VIC-II) Registers       $d000-$d02e
C64Kernal               include c64_kernal.asm            ; Kernal Routines entry points                  $e000-$ffff
C64Memory               include c64_mem.asm               ; Standard Zeropage / Stack / Vector constants


VC1541Dir               include vc1541_dir.asm            ; Directory constants
VC1541Dos               include vc1541_dos.asm            ; DOS ROM                                       $c100-$ffff
VC1541Memory            include vc1541_mem.asm            ; Standard Zeropage / Stack / Vector constants
VC1541VIA1              include vc1541_via1.asm           ; VIA #1 registers - Port Serial Bus            $1800-$1800
VC1541VIA2              include vc1541_via2.asm           ; VIA #2 registers - Port Motor / Head Control  $1c00-$1c00
VC1541File              include vc1541_file.asm           ; File Data Block

ZeroPage                include inc\BBL_Zpg.asm           ; Zero Page Addresses
; -------------------------------------------------------------------------------------------------------------- ;
; External Addresses
; -------------------------------------------------------------------------------------------------------------- ;
C64_New_KernalRoutines  = $f800                           ; start address of new C64 load data routines
; -------------------------------------------------------------------------------------------------------------- ;
; BobLoad_Main          Does    : Copy OLD C64 kernal code to RAM / Install the new C64 kernal code
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobLoad_Main            subroutine                        ; 
                        sei                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Copy kernal ROM to RAM
; -------------------------------------------------------------------------------------------------------------- ;
.Copy_C64_OldKernal_Ini ldy #<KERNAL_ROM                  ; 
                        sty BBLZ_CopyDataPtrLo            ; 
                        lda #>KERNAL_ROM                  ; 
                        sta BBLZ_CopyDataPtrHi            ; 
                        
.Copy_C64_OldKernal     lda (BBLZ_CopyDataPtr),y          ; 
                        sta (BBLZ_CopyDataPtr),y          ; 
                        iny                               ; 
                        bne .Copy_C64_OldKernal           ; 
                        inc BBLZ_CopyDataPtrToHi          ; 
                        bne .Copy_C64_OldKernal           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Overwrite old kernal in RAM with new kernal routines
; -------------------------------------------------------------------------------------------------------------- ;
.Copy_C64_NewKernal_Ini lda #>C64_New_KernalRoutines      ; target memory
                        sta BBLZ_CopyDataPtrToHi          ; 
                        
                        lda #<CopyCode_Kernal             ; from memory
                        ldx #>CopyCode_Kernal             ; 
                        sta BBLZ_CopyDataPtrFromLo        ; 
                        stx BBLZ_CopyDataPtrFromHi        ; 
                        
.Copy_C64_NewKernal     lda (BBLZ_CopyDataPtrFrom),y      ; $08bf
                        sta (BBLZ_CopyDataPtrTo),y        ; $f800 - overwrite cassette routines
                        iny                               ; 
                        bne .Copy_C64_NewKernal           ; 
                        
.Inc_C64_NewKernal_Max  inc BBLZ_CopyDataPtrFromHi        ; 
                        inc BBLZ_CopyDataPtrToHi          ; 
                        
.Get_C64_NewKernal_Max  lda BBLZ_CopyDataPtrToHi          ; 
.Chk_C64_NewKernal_Max  cmp #>[C64_New_KernalRoutines + CopyCode_Kernal_Len] ; $fc
                        bcc .Copy_C64_NewKernal           ; lower
; -------------------------------------------------------------------------------------------------------------- ;
; Update kernal IOINT (Initialise I/O) routine
; -------------------------------------------------------------------------------------------------------------- ;
.Get_C64_NewIOINIT      lda #[$e0 | Mem_BasOn | Mem_IoOn] ; 
                        sta [_IOINIT + $33]               ; routine: init I/O devices ($fdd5 lda #$e7 --> $fdd5 lda #$e5)
; -------------------------------------------------------------------------------------------------------------- ;
; Update kernal DiskHandler / KeyLog
; -------------------------------------------------------------------------------------------------------------- ;
.Copy_C64NewCode_Ini    ldx #CopyCode_C64_New_Len         ; 
.Copy_C64NewCode        lda CopyCode_C64_New,x            ; 
                        sta C64_FastLoadCtrl,x            ; new Kernal LOAD routine vectored by NewKernalRoutine-->ILOAD
                        dex                               ; 
                        bpl .Copy_C64NewCode              ; 
                        
                        jsr SetFastLoadVector             ; 
                        
.SetNewLoadVector       sta VLOAD                         ; #<C64_FastLoadCtrl - kernal LOAD: Load/verify RAM from a device via ILOAD
                        stx [VLOAD + $01]                 ; #>C64_FastLoadCtrl
                        
                        lda #<C64_Keylog                  ; 
                        ldx #>C64_Keylog                  ; 
.SetNewScreenInit       sta [_CINT1 + $0b]                ; update fetch pointer LO to keyboard decode tab (from:$eb48 to:)
                        stx [_CINT1 + $10]                ; update fetch pointer HI to keyboard decode tab (from:$eb48 to:)
                        
                        cli                               ; 
                        
BobLoad_MainX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_C64_New        equ  *                            ; 
                        rorg $02c0                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64_FastLoadCtrl      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_FastLoadCtrl        subroutine                        ; 
                        pha                               ; 
                        
                        lda #[$00 | Tap_Ini | IO_ON  & KERNAL_OFF | BASIC_ON] ; IO - RAM - RAM -> BASIC off too because KERNAL off
                        sta R6510                         ; 
                        
                        pla                               ; 
                        
.GoFastLoad             jsr C64_FastLoader                ; 
                        
                        pha                               ; 
                        
                        lda #<SHFLOG                      ; Evaluate 'SHIFT' 'CTRL' 'CBM' keys / Init keyboard decode table
                        sta KEYLOG                        ; Vector: Evaluate the SHIFT/CTRL/C= keys
                        lda #>SHFLOG                      ; Evaluate 'SHIFT' 'CTRL' 'CBM' keys / Init keyboard decode table
                        sta [KEYLOG + $01]                ; 
                        
                        lda #[$00 | Tap_Ini | Mem_IoOn | Mem_KerOn | Mem_BasOn] ; IO - Basic - Kernal - switch all on
                        sta R6510                         ; 
                        
                        pla                               ; 
                        
C64_FastLoadCtrlX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64_Keylog            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_Keylog              subroutine                        ; 
                        lda #[$00 | Tap_Ini | IO_ON  & KERNAL_OFF | BASIC_ON] ; IO - RAM - RAM -> BASIC off too because KERNAL off
                        sta R6510                         ; 
                        
C64_KeylogX             jmp SHFLOG                        ; Evaluate 'SHIFT' 'CTRL' 'CBM' keys / Init keyboard decode table
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_C64_New_Len    equ [* - C64_FastLoadCtrl]        ; 
                        rend                              ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_Kernal         equ  *                            ; 
SetFastLoadVector       equ  *                            ; point to actual code for 1st time init
; -------------------------------------------------------------------------------------------------------------- ;
                        rorg C64_New_KernalRoutines       ; point to new kernal memory $f800
; -------------------------------------------------------------------------------------------------------------- ;
; Start: The New C64 Kernal Routines
; -------------------------------------------------------------------------------------------------------------- ;
; C64_SetFastLoadVector Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_SetFastLoadVector   subroutine                        ; 
                        lda #<C64_FastLoadCtrl            ; 
                        ldx #>C64_FastLoadCtrl            ; 
                        
.SetNewLoadVector       sta ILOAD_LO                      ; Vector($0330/$0331): Indirect entry to Kernal LOAD routine at ($F4A5)
                        stx ILOAD_HI                      ; 
                        
C64_SetFastLoadVectorX  rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64_GetSerialPage     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_GetSerialPage       subroutine                        ; 
                        sei                               ; 

.IniReadyToReceive_No   lda #[$00 | CI2_PA_Data_Out_Yes | CI2_PA_RS2_Out_Yes | CI2_VIC_MemBankSet] ; 
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
.WaitSerialBus          bit CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
.TestSerialBus          bvc .WaitSerialBus                ; bit6=CI2_PA_CLOCK_IN - Serial bus data input
                        
.GetReadyStartSend      lda #[$00 & CI2_PA_Data_Out_No & CI2_PA_RS2_Out_No | CI2_VIC_MemBankSet] ; OK - start sending
.SetReadyStartSend      sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        ldx #$09                          ; 
.WaitForFloppyData      dex                               ; give floppy enough time to make the data available
                        bne .WaitForFloppyData            ; 
                        
.IniDataBitPairsMax     ldx #$04                          ; 1 byte = $04 * $02 bits
.GetNextDataBitPair     lda CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        asl a                             ; get   bit7 - CI2_PA_SERIAL_IN <- CI2_PA_DATA_IN
                        php                               ; save  bit7                                                  
                        asl a                             ; get   bit6 - CI2_PA_SERIAL_IN <- CI2_PA_CLOCK_IN
                        rol BBLZ_ByteFromSerialBus        ; store bit6
                        plp                               ; get   bit7
                        rol BBLZ_ByteFromSerialBus        ; store bit7
                        
.SetNextDataBitPair     dex                               ; get next 2 bits
                        bne .GetNextDataBitPair           ; 
                        
                        lda BBLZ_ByteFromSerialBus,x      ; X=$00
                        sta (EAL),y                       ; 
                        
                        iny                               ; 
                        bne .IniDataBitPairsMax           ; 
                        
.SetReadyToReceive_No   lda #[$00 | CI2_PA_Clk_Out_Yes | CI2_PA_RS2_Out_Yes | CI2_VIC_MemBankSet] ; $03 = $0000-$3fff
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        lda BBLZ_ByteFromSerialBus        ; 
                        
C64_GetSerialPageX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64_GetSerialByte     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_GetSerialByte       subroutine                        ; 
                        sei                               ; 
                        
.IniReadyToReceive_No   lda #[$00 | CI2_PA_Data_Out_Yes | CI2_PA_RS2_Out_Yes | CI2_VIC_MemBankSet] ; 
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
.WaitSerialBus          bit CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
.TestSerialBus          bvc .WaitSerialBus                ; bit6=CI2_PA_CLOCK_IN - Serial bus data input
                        
.GetReadyStartSend      lda #[$00 & CI2_PA_Data_Out_No & CI2_PA_RS2_Out_No | CI2_VIC_MemBankSet] ; OK - start sending
.SetReadyStartSend      sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        ldx #$08                          ; 
.WaitForFloppyData      dex                               ; give floppy enough time to make the data available
                        bne .WaitForFloppyData            ; 
                        
.IniDataBitPairsMax     ldx #$04                          ; 1 byte = $04 * $02 bits
.GetNextDataBitPair     lda CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        asl a                             ; get   bit7 - CI2_PA_SERIAL_IN <- CI2_PA_DATA_IN
                        php                               ; save  bit7                                                  
                        asl a                             ; get   bit6 - CI2_PA_SERIAL_IN <- CI2_PA_CLOCK_IN
                        rol BBLZ_ByteFromSerialBus        ; store bit6
                        plp                               ; get   bit7
                        rol BBLZ_ByteFromSerialBus        ; store bit7
                        
.SetNextDataBitPair     dex                               ; get next 2 bits
                        bne .GetNextDataBitPair           ; 
                        
.SetReadyToReceive_No   lda #[$00 | CI2_PA_Clk_Out_Yes | CI2_PA_RS2_Out_Yes | CI2_VIC_MemBankSet] ; $03 = $0000-$3fff
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
.KeepSync               nop                               ; 
                        nop                               ; 
                        nop                               ; 
                        
                        lda BBLZ_ByteFromSerialBus        ; 
                        
C64_GetSerialByteX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64_FastLoader        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64_FastLoader          subroutine                        ; 
                        sta VERCKK                        ; Flag: Type of load ($00=load/$01=verify)
                        
                        lda #$00                          ; 
                        sta STATUS                        ; I/O Status Word (ST)
                        
                        lda FA                            ; Current File: First address (Device number)
.ChkDeviceFloppy        cmp #$08                          ; 
.WasDeviceFloppy        beq .GetFileNameLen               ; 
                        
.GoGetDeviceAdr         jmp [_LOAD + $0d]                 ; get device address
                        
.GetFileNameLen         ldy FNLEN                         ; Current File: Name length
                        bne .SetFileNameBufLen            ; 
                        
.Error_MissingFileName  jmp [_IOERROR + $07 * $03]        ; ioerror_8 - missing file name
                        
.SetFileNameBufLen      sty C64_FileNameLen               ; --> $0a
                        
                        ldy #$00                          ; 
.GetNextFileNameChar    lda (FNADR),y                     ; Current File: Address of file name
                        sta C64_FileName,y                ; --> BOUNTY BOB
                        cpy #$00                          ; 
                        bne .SetNextFileNameBuf           ; 
                        
                        cmp #"$"                          ; 
                        beq .GoGetDeviceAdr               ; 
                        
.SetNextFileNameBuf     iny                               ; 
.ChkFileNameLen         cpy FNLEN                         ; 
                        bcc .GetNextFileNameChar          ; lower
                        
                        jsr _LOAD_MSG_SF                  ; print "searching for <filename>"/"loading"
                        
                        lda NMINV_LO                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        pha                               ; 
                        lda NMINV_HI                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        pha                               ; 
                        
.NMI_DisAllow           lda #<[_NMI_RS_232 + $4f]         ; rti
                        ldx #>[_NMI_RS_232 + $4f]         ; 
                        sta NMINV_LO                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        stx NMINV_HI                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        
.IniTimerB              lda #$82                          ; bit1=enable or disable Timer B interrupt bit7=timer interrupt
                        sta CI2ICR                        ; CIA2($DD0D) Interrupt Control Register
                        
                        lda #$01                          ; 
                        sta TI2BLO                        ; CIA2($DD06) Timer B (low byte)
                        lda #$00                          ; 
                        sta TI2BHI                        ; CIA2($DD07) Timer B (high byte)
                        
                        lda #$19                          ; ...# #..# - bit0=start timer b
                        sta CI2CRB                        ; CIA2($DD0F) Control Register B
                        
                        lda #$08                          ; .... #... - bit3=timer run mode
                        sta CI2CRB                        ; CIA2($DD0F) Control Register B
                        
.NMI_ReAllow            pla                               ; 
                        sta NMINV_HI                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        pla                               ; 
                        sta NMINV_LO                      ; Vector($0318/$0319): Hardware NMI interrupt address at ($FE47)
                        
                        lda SPENA                         ; VIC($D015) Sprite Enable Register
                        sta BBLZ_SpriteEnabSav            ; 
                        
                        lda #$00                          ; 
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Write code over to the 1541 main working buffer_0
; -------------------------------------------------------------------------------------------------------------- ;
.MemoryWrite_VC1541     lda #<CopyCode_1541               ; transfer code to 1541
                        ldx #>CopyCode_1541               ; 
                        sta BBLZ_1541_Code_From_Lo        ; 
                        stx BBLZ_1541_Code_From_Hi        ; 
                        
.IniOutBufferPtr        ldx #<BUF0                        ; 
                        lda #>BUF0                        ; 
                        stx BBLZ_1541_BUF0_Lo             ; 
                        sta BBLZ_1541_BUF0_Hi             ; 
                        
.SetSerListen           lda #$08                          ; 
                        jsr _LISTEN                       ; Send LISTEN Command on Serial Bus
                        
                        lda #$6f                          ; $60 + $0f
                        jsr _SECOND                       ; Send LISTEN Secondary Address
                        
.ChkConditionCode       lda STATUS                        ; 
.Was_OK                 bpl .MW_CmdOut                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; With D64 files STATUS here always returns a $80 - Device not present error 
; This Leads to:
;   LAbel ".Was_Error" will be dispatched 
;   Returns OK via label ".GetStatus_OK" but does not load the "bounty bob" main program code
;   Abends then on calling "InitOnce" of the "bounty bob" main program
; Solution:
;   Use the G64 file in conjunction with "Drive Settings / True Drive Emulation"
; -------------------------------------------------------------------------------------------------------------- ;
.Was_Error              lda #$80                          ; ST_SER_NO_DEV - Device not present error
                        sta BBLZ_DataByteWork             ; 
                        
                        jmp .GetStatus_OK                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
.MW_CmdOut              lda #$4d                          ; "M"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        lda #$2d                          ; "-"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        lda #$57                          ; "W"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
.MW_DataAdrLo           lda BBLZ_1541_BUF0_Lo             ; 
                        jsr _CIOUT                        ; Send Serial Deferred
                        
.MW_DataAdrHi           lda BBLZ_1541_BUF0_Hi             ; 
                        jsr _CIOUT                        ; Send Serial Deferred
                        
.MW_DataLen             lda #$1d                          ; data length
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        ldy #$00                          ; 
.MW_DataOut             lda (BBLZ_1541_Code_From),y       ; 
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        iny                               ; 
.MW_ChkLen              cpy #$1d                          ; a max $23 bytes allowed to send to floppy in one step
                        bcc .MW_DataOut                   ; lower
                        
.IniNextPortion         jsr _UNLSN                        ; Send UNLISTEN
                        
.SetNextPortion         clc                               ; point to next data portion
.MW_NextBufferIn        lda BBLZ_1541_Code_From_Lo        ; 
                        adc #$1d                          ; 
                        sta BBLZ_1541_Code_From_Lo        ; 
                        bcc .MW_NextBufferOut             ; 
                        inc BBLZ_1541_Code_From_Hi        ; 
                        
                        clc                               ; 
.MW_NextBufferOut       lda BBLZ_1541_BUF0_Lo             ; 
                        ldx BBLZ_1541_BUF0_Hi             ; 
                        adc #$1d                          ; 
                        sta BBLZ_1541_BUF0_Lo             ; 
                        bcc .MW_ChkBufferMax              ; 
                        inx                               ; 
                        inc BBLZ_1541_BUF0_Hi             ; 
                        
.MW_ChkBufferMax        cpx #$04                          ; 
                        bcc .SetSerListen                 ; lower
                        
                        cmp #$e4                          ; 
                        bcc .SetSerListen                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Exec the copied code on the 1541
; -------------------------------------------------------------------------------------------------------------- ;
.SwitchScreen_Off       lda SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        and #VIC_Screen_Off               ; 
                        sta SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
.MemoryExec_VC1541      lda #$08                          ; 
                        jsr _LISTEN                       ; Send LISTEN Command on Serial Bus
                        
                        lda #$6f                          ; $60 + $0f
                        jsr _SECOND                       ; Send LISTEN Secondary Address
                        
.ME_CmdString           lda #$4d                          ; "m"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        lda #$2d                          ; "-"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
                        lda #$45                          ; "e"
                        jsr _CIOUT                        ; Send Serial Deferred
                        
.ME_PgmStartAdr_Lo      lda #<VC1541_Start                ; 
                        jsr _CIOUT                        ; Send Serial Deferred
                        
.ME_PgmStartAdr_Hi      lda #>VC1541_Start                ; 
                        jsr _CIOUT                        ; Send Serial Deferred
                        jsr _UNLSN                        ; Send UNLISTEN
                        
.SetReadyToReceive_No   lda #[$00 & CI2_PA_Data_Out_No | CI2_PA_RS2_Out_Yes | CI2_VIC_MemBankSet] ; 
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
; -------------------------------------------------------------------------------------------------------------- ;
; Wait for Memory Exec command to finish
; -------------------------------------------------------------------------------------------------------------- ;
.Ini_ME_CmdWait         ldx #$00                          ; 
.Dec_ME_CmdWait         dex                               ; 
.Chk_ME_CmdWait         bne .Dec_ME_CmdWait               ; 
; -------------------------------------------------------------------------------------------------------------- ;
.IniStatus_FileNotFound stx BBLZ_DataByteWork             ; $00 - preset Error_FileNotFound
; -------------------------------------------------------------------------------------------------------------- ;
; Get data sent from VC1541
; -------------------------------------------------------------------------------------------------------------- ;
.GetFileDataNext        jsr C64_GetSerialByte             ; ----< Get 1st: File Link TT >----
.Chk_File_Error         cmp #$ff                          ; Flag: File Not Found
.Was_File_Error         beq .SwitchScreen_ON              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Receive Data from Floppy VC1541
; -------------------------------------------------------------------------------------------------------------- ;
.Was_File_OK            ldy #PRGDATANEXT                  ; block data offset NEXT file data block - PRGLINK only
                        
.GetStatus              ldx BBLZ_DataByteWork             ; 1st Time: $00
.ChkStatus              bne .ChkFileDataLast              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Handle FIRST Data Block
; -------------------------------------------------------------------------------------------------------------- ;
.FileLink_Save          pha                               ; 
                        
.ReadStartOfProgram_Lo  jsr C64_GetSerialByte             ; ----< Get 2nd: File Load Address Low >----
                        tay                               ; 
                        
.ReadStartOfProgram_Hi  jsr C64_GetSerialByte             ; ----< Get 3rd: File Load Address High >----
                        
                        ldx SA                            ; Current File: Secondary address
                        bne .SetStartOfProgram            ; was "LOAD file,8,1"
                        
.GetStartOfProgram_Std  ldy MEMUSS_LO                     ; Buffer START address for LOAD/APPEND
                        lda MEMUSS_HI                     ; Buffer START address for LOAD/APPEND
                        
.SetStartOfProgram      sty EAL_LO                        ; Buffer END address for WRITE/SAVE - End of program
                        sta EAL_HI                        ; Buffer END address for WRITE/SAVE - End of program
                        
.GetSyncLen             ldy #PRGDATAFIRST                 ; block data offset FIRST file data block - PRGLINK + PRGLOAD
                        
.FileLink_Restore       pla                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Handle NEXT Data Block
; -------------------------------------------------------------------------------------------------------------- ;
.ChkFileDataLast        cmp #PRGLINKLAST                  ; 
                        beq .GetSerialReadAmount          ; 
                        
.SavBufferDataPtr       sty BBLZ_DataByteWork             ; 
                        
.DiscountDataOffset     sec                               ; 
                        lda EAL_LO                        ; Pointer: End of program
                        sbc BBLZ_DataByteWork             ; 
                        sta EAL_LO                        ; Pointer: End of program
                        bcs .GetNextBufferDataPage        ; 
                        dec EAL_HI                        ; Pointer: End of program
                        
.GetNextBufferDataPage  jsr C64_GetSerialPage             ; ----< Get 4th: File Data Block >----
                        
.IncBufferDataPagePtr   inc EAL_HI                        ; Pointer: End of program
                        bne .GetFileDataNext              ; always (hopefully)
; -------------------------------------------------------------------------------------------------------------- ;
; Handle LAST Data Block
; -------------------------------------------------------------------------------------------------------------- ;
.GetSerialReadAmount    jsr C64_GetSerialByte             ; ----< Get 5th: Last File Data Block Use Count >----
                        sta BBLZ_DataByteWork             ; 
                        
                        ldy #$00                          ; 
.CheckGotSerialByte     lda BBLZ_DataByteWork             ; 
                        cmp #$02                          ; 
                        bcc .GetStatus_OK                 ; lower
                        
                        jsr C64_GetSerialByte             ; ----< Get 6th: Last File Data Block Single Bytes >----
.PutDataBuffer          sta (EAL),y                       ; fill data buffer
                        
.IncDataBufferPtr       iny                               ; set next data buffer pos
                        
.DecSerialReadAmount    dec BBLZ_DataByteWork             ; 
                        bne .CheckGotSerialByte           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Disk Data Read Successfully
; -------------------------------------------------------------------------------------------------------------- ;
.GetStatus_OK           lda #$ff                          ; 
.SetStatus_OK           sta BBLZ_DataByteWork             ; happy ending
; -------------------------------------------------------------------------------------------------------------- ;
.SetEndOfProgramPtr     tya                               ; data buffer pointer
                        clc                               ; 
                        adc EAL_LO                        ; 
                        sta EAL_LO                        ; Pointer: End of program
                        bcc .SwitchScreen_ON              ; 
                        inc EAL_HI                        ; Pointer: End of program
; -------------------------------------------------------------------------------------------------------------- ;
; Reset C64 / Check Result
; -------------------------------------------------------------------------------------------------------------- ;
.SwitchScreen_ON        lda SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        ora #VIC_Screen_On                ; 
                        sta SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
                        lda BBLZ_SpriteEnabSav            ; 
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
                        
                        lda CI2ICR                        ; CIA2($DD0D) Interrupt Control Register
.ClearInterrupt         lda #$7f                          ; .#######
                        sta CI2ICR                        ; CIA2($DD0D) Interrupt Control Register
                        
                        cli                               ; 
                        
.Error_Status_Get       lda BBLZ_DataByteWork             ; 
.Error_Status_Check     bne .Error_Device_Check           ; may still be good in case of $ff
                        
.Error_FileNotFound     jmp [_IOERROR + $03 * $03]        ; ioerror_4 - file not found
                        
.Error_Device_Check     cmp #ST_SER_NO_DEV                ; Status: Device not present
                        bne C64_FastLoaderX               ; 
                        
.Error_DeviceNotPresent jmp [_IOERROR + $04 * $03]        ; ioerror_5 - device not present
                        
C64_FastLoaderX         jmp [_LOAD_SERIAL + $f1]          ; $ff - set ok (clc) / store end address in EAL / rts
; -------------------------------------------------------------------------------------------------------------- ;
; End of Data New Kernal Routines
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Start: Code copied over to 1541 BUF0
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_1541           equ *                             ; 
                        rorg BUF0                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_GoFindHdrBlock Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_GoFindHdrBlock   subroutine                        ; 
                        jmp VC1541_SeekFileBlock          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_Start          Does    : Entry Point Floppy Code
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_Start            subroutine                        ; 
                        lda #SERCNT_CLKOUT                ; 
.SetNotReady            sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code running - not ready to send
                        
VC1541_StartX           jmp VC1541_FindFileNameIni        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_FileBlockSend  Does    : Sends a complete data buffer to the serial bus
;                               : Sync only at start - no further syncs via CLK - CLK now free to send a 2nd data bit
;                               : C64: interrupts and vic screen switched off to keep sync
;                       Expects : yr=buffer pos
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FileBlockSend    subroutine                        ; yr=$02 / yr=$04
.SerCnt_Ini_DATIN       ldx #SERCNT_DATIN                 ; 
                        
.Interrupt_Allow        cli                               ; 
                        
.SerCnt_Set_DATIN_01    txa                               ; SERCNT_DATIN
                        
.SerCnt_Wait_C64_RDY_01 bit SERCNT                        ; VIA1($1800) 1541 Data Port B -> 
                        beq .SerCnt_Wait_C64_RDY_01       ; 
                        
.Interrupt_Forbid       sei                               ; 
                        
.SerCnt_GetReady        lda #$00                          ; 
.SerCnt_SetReady        sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code stopped - ready to send
                        
.SerCnt_Set_DATIN_02    txa                               ; SERCNT_DATIN
                        
.SerCnt_Wait_C64_RDY_02 bit SERCNT                        ; VIA1($1800) 1541 Data Port B -> 
                        bne .SerCnt_Wait_C64_RDY_02       ; SERCNT_ATN - ATTENTION IN from serial bus
                        
                        nop                               ; 
                        
.IniNextShiftRounds     ldx #$04                          ; send $04 * $02 bits 1=Bit5 & Bit7 / 2=Bit4 & Bit6 / 3=Bit1 & Bit3 / 4=Bit0 & Bit2
                        
.GetNextDataByte        lda (BBLZ_DirBlockPtr),y          ; 
.InvertDataByte         eor #$ff                          ; for correct receive
.SetNextDataByte        sta BBLZ_DataByte                 ; 
                        
.IniSendDataByte        lda #$00                          ; clear ac
                        asl BBLZ_DataByte                 ; shift data bits to their correct position
                        rol a                             ; 
                        asl a                             ; 
                        asl BBLZ_DataByte                 ; 
                        rol a                             ; 
                        asl a                             ; 
                        
.SendTwoDataBits        sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> send 2 data bits in CLOCK OUT / DATA OUT
                        
.DecNextShiftRounds     dex                               ; 
.NextShiftRound         bne .IniSendDataByte              ; 
                        
.WaitForReceive_1       nop                               ; wait 6 cycles - give the C64 enough time to receive the data byte
                        nop                               ; 
                        nop                               ; 
                        
.SetNextShiftByte       iny                               ; 
.NextShiftByte          bne .IniNextShiftRounds           ; 
                        
.WaitForReceive_2       nop                               ; wait 6 cycles - give the C64 enough time to receive the data byte
                        nop                               ; 
                        nop                               ; 
                        
                        lda #SERCNT_CLKOUT                ; 
.SetNotReady            sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code running - not ready to send
                        
VC1541_FileBlockSendX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_DataByteSend   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_DataByteSend     subroutine                        ; 
.InvertDataByte         eor #$ff                          ; 
                        
.Interrupt_Allow        cli                               ; 
                        
                        sta BBLZ_DataByte                 ; 
                        
.SerCnt_Ini_DATIN       ldx #SERCNT_DATIN                 ; 
.SerCnt_Set_DATIN_01    txa                               ; SERCNT_DATIN
                        
.SerCnt_Wait_C64_RDY_01 bit SERCNT                        ; VIA1($1800) 1541 Data Port B -> 
                        beq .SerCnt_Wait_C64_RDY_01       ; 
                        
.Interrupt_Forbid       sei                               ; 
                        
.SerCnt_GetReady        lda #$00                          ; 
.SerCnt_SetReady        sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code stopped - ready to send
                        
.SerCnt_Set_DATIN_02    txa                               ; SERCNT_DATIN
                        
.SerCnt_Wait_C64_RDY_02 bit SERCNT                        ; VIA1($1800) 1541 Data Port B -> 
                        bne .SerCnt_Wait_C64_RDY_02       ; SERCNT_ATN - ATTENTION IN from serial bus
                        
.IniNextShiftRounds     ldx #$04                          ; send $04 * $02 bits 1=Bit5 & Bit7 / 2=Bit4 & Bit6 / 3=Bit1 & Bit3 / 4=Bit0 & Bit2
.IniSendDataByte        lda #$00                          ; clear ac
                        asl BBLZ_DataByte                 ; 
                        rol a                             ; 
                        asl a                             ; 
                        asl BBLZ_DataByte                 ; 
                        rol a                             ; 
                        asl a                             ; 
                        
.SendTwoDataBits        sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> send 2 data bits in CLOCK OUT / DATA OUT
                        
.DecNextShiftRounds     dex                               ; 
.NextShiftRound         bne .IniSendDataByte              ; 
                        
                        ldx #$03                          ; 
.Wait                   dex                               ; 
                        bne .Wait                         ; 
                        
                        lda #SERCNT_CLKOUT                ; 
.SetNotReady            sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code running - not ready to send
                        
VC1541_DataByteSendX    rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_FindFileNameIni Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FindFileNameIni  subroutine                        ; 
.SwitchOnDriveLED       jsr LEDSON                        ; set bit 3 of DSKCNT ($1C00) to turn on drive active LED for drive 0
                        
.GetDirectoryDataPtr    lda #<BUF3                        ; $0600
                        ldx #>BUF3                        ; 
                        
.SetDirectoryDataPtr    sta BBLZ_DirBlockPtrLo            ; 
                        stx BBLZ_DirBlockPtrHi            ; 
                        
.SetFlag_Block_01       sta BBLZ_FlagBlockFirst           ; normally: JOB4TRA - buffer #4 - track
                        
.GetWorkBuf_6           lda #$06                          ; 
.SetWorkBuf_6           sta JOBNUM                        ; buffer #6 - current work buffer
                        
.GetRetryCount          lda #$02                          ; 
.SetRetryCount          sta REVCNT                        ; number of retries on dos commands in case of an error
                        
.GetDirBlock_TT         lda #$12                          ; 18 -> track  1st directory block
.SetDirBlock_TT_J0      sta JOB0TRA                       ; buffer #0 - track
                        
.GetDirBlock_SS         lda #$01                          ; 01 -> sector 1st directory block
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_FindFileName   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FindFileName     subroutine                        ;                         
.SetNextDirBlock_SS_J0  sta JOB0SEC                       ; set next dir block sector
                        jsr VC1541_SeekSector             ; 
                        
.GetErrorNum            ldy #$23                          ; preset error number: 23, READ ERROR
                        
.ChkCondCode            cmp #JOBST_OK                     ; 
.Was_BAD                bne ExitWithErrorMsg              ; 
                        
.IniNextFileNameDirOff  ldy #$00                          ; was OK - ini dir block entry pointer
.ChkNextDirFileType     lda [BUF3 + DIRFTYP],y            ; filetype
                        and #DIRFTYP_MASK_NORMAL          ; reduce to 'normal' filetypes
.ChkNextDirFileType_PRG cmp #DIRFTYP_PRG                  ; select program files only
                        bne .SetNextDirBlockEntry         ; 
                        
.IniFileNameBufOff      ldx #$00                          ; 
                        beq .GetWildCardWhole             ; always check for wildcard 1st
                        
.GetFileNameBuf         lda VC1541_FileName,x             ; compare file name to load ...
.ChkFileNameDir         cmp [BUF3 + DIRFILENAM],y         ; ... with actual dir block file name
                        beq .SetNextFileNamePos           ; 
                        
.ChkWildCardSingle      cmp #"?"                          ; 
                        bne .SetNextDirBlockEntry         ; 
                        
                        lda [BUF3 + DIRFILENAM],y         ; offset filename
                        cmp #$a0                          ; shift_space
.ChkEndOfFileName       beq .SetNextDirBlockEntry         ; 
                        
.SetNextFileNamePos     inx                               ; file name pointer
                        iny                               ; dir entry pointer
                        
.SetNextFileNameMax     cpx VC1541_FileNameLen            ; 
                        bcs .GetFileNameDirPtr            ; greater/equal
                        
.GetWildCardWhole       lda VC1541_FileName,x             ; 
.ChkWildCardWhole       cmp #"*"                          ; 
                        beq VC1541_FileBlockStart         ; 
                        bne .GetFileNameBuf               ; always
                        
.GetFileNameDirPtr      tya                               ; directory entry pointer
.GetFileNameLen         and #[DIRENTRYLEN - $01]          ; mask out possible DIR2ND to DIR8TH entry offsets
.ChkFileNameLen         cmp #[DIRFILENAM_LEN + $01]       ; 
                        bcs VC1541_FileBlockStart         ; greater/equal - file name found
                        
                        lda [BUF3 + DIRFILENAM],y         ; lower - check for filler char
.ChkFileNameFiller      cmp #$a0                          ; shift_space -  file name found
                        beq VC1541_FileBlockStart         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; File Not Found in actual dir block / Try Next
; -------------------------------------------------------------------------------------------------------------- ;
.SetNextDirBlockEntry   tya                               ; 
.GetThisDirEntry        and #DIR8TH                       ; ###..... - offset last dir block entry
                        clc                               ; 
                        adc #DIRENTRYLEN                  ; 
.SetNextDirEntry        tay                               ; 
.ChkEndOfDirBlock       bcc .ChkNextDirFileType           ; 
                        
.GetNextDirLink_TT      lda [BUF3 + DIRLINKTRK]           ; next directory block track
.ChkNextDirLink_TT      bne .GetNextDirLink_SS            ; still not last dir block
                        
.WasLastDirBlock        ldy #$62                          ; Error number: 62, FILE NOT FOUND
; -------------------------------------------------------------------------------------------------------------- ;
; File Not Found in whole directory
; -------------------------------------------------------------------------------------------------------------- ;
ExitWithErrorMsg        lda #$ff                          ; get error code byte
.Send_Error             jsr VC1541_DataByteSend           ; 
                        
                        lda #$00                          ; 
.SerCnt_Ready           sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code stopped - ready to send
                        
.SetErrorNum            tya                               ; Error number: 62, FILE NOT FOUND
.Error_Exit             jmp CMDERR                        ; command level error handling: .A must contain the error number
; -------------------------------------------------------------------------------------------------------------- ;
; Continue with next Dir block
; -------------------------------------------------------------------------------------------------------------- ;
.GetNextDirLink_SS      lda [BUF3 + DIRLINKSEC]           ; next directory block sector
                        
VC1541_FindFileNameX    jmp .SetNextDirBlock_SS_J0        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_SeekFileBlock  Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_SeekFileBlock    subroutine                        ; 
                        lda #>BUF3                        ; 
                        sta BUFPNT_HI                     ; pointer: begin of currently active buffer
                        
VC1541_SeekFileBlockX   jmp [REED + $07]                  ; JSR to DSTRT ($f50a) - find header and set up to the start of the data block
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_FileBlockStart Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FileBlockStart   subroutine                        ; 
                        tya                               ; 
.LimitBlockDataPtr      and #DIR8TH                       ; ###.....
                        tay                               ; 
                        
.GetTrack               lda [BUF3 + DIRFILETRK],y         ; pgm dir block entry - start data block track number
                        sta JOB0TRA                       ; buffer #0 - track
                        
.GetSector              lda [BUF3 + DIRFILESEC],y         ; pgm dir block entry - start data block sector number
VC1541_FileBlockStart_X sta JOB0SEC                       ; buffer #0 - sector
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_FileDataSend   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FileDataSend     subroutine                        ; 
.SeekNextFileBlock      jsr VC1541_SeekSector             ; 
                        
.GetErrorNum            ldy #$23                          ; Error number: 23, READ ERROR
                        
.ChkConditionCode       cmp #JOBST_OK                     ; 
.Was_BAD                bne ExitWithErrorMsg              ; end the transmission
                        
.GetFileBlockNext_TT_01 lda [BUF3 + PRGLINKTRK]           ; file block found - set track of next file block
.SetFileBlockNext_TT_01 sta JOB0TRA                       ; buffer #0 - track
.OutFileBlockNext_TT_01 jsr VC1541_DataByteSend           ; ----< Send 1st: File Link TT >----
                        
.ChkFlag_FileBlock_01   lda BBLZ_FlagBlockFirst           ; check if FIRST file data block
.WasFlag_FileBlock_nn   bne .GetDataStartBlock_nn         ; BBLZ_FlagBlockFirst_No
                        
.SetFlag_FileBlock_nn   inc BBLZ_FlagBlockFirst           ; set BLZ_FlagBlockFirst_Yes
                        
.GetFileLoadAdr_Lo      lda [BUF3 + PRGLOADLO]            ; file load address low byte
.OutFileLoadAdr_Lo      jsr VC1541_DataByteSend           ; ----< Send 2nd: File Load Address Low >----
                        
.GetFileLoadAdr_Hi      lda [BUF3 + PRGLOADHI]            ; pgm start track
.OutFileLoadAdr_Hi      jsr VC1541_DataByteSend           ; ----< Send 3rd: File Load Address High >----
                        
.GetDataStartBlock_01   ldy #PRGDATAFIRST                 ; file link TT_SS + load address LO_HI
                        bne .GetFileBlockNext_TT_nn       ; always
                        
.GetDataStartBlock_nn   ldy #PRGDATANEXT                  ; file link TT_SS only
                        
.GetFileBlockNext_TT_nn lda JOB0TRA                       ; buffer #0 - next track
.ChkFileBlockLast       beq .GetFileBlockLast_Count       ; PRGLINKLAST = id last PGM file data block
                        
.OutFileBlock           jsr VC1541_FileBlockSend          ; ----< Send 4th: File Data Block >----
                        
.GetFileBlockNext_SS_nn lda [BUF3 + PRGLINKSEC]           ; pgm sector next data block
.SetFileBlockNext_SS_nn sta JOB0SEC                       ; buffer #0 - next sector
                        
.OutFileBlockNext       jmp .SeekNextFileBlock            ; TT ans SS set to next file data block
; -------------------------------------------------------------------------------------------------------------- ;
; Send content of last file data block byte by byte
; -------------------------------------------------------------------------------------------------------------- ;
.GetFileBlockLast_Count lda [BUF3 + DIRLINKSEC]           ; pgm sector next data block
.OutFileBlockLast_Count jsr VC1541_DataByteSend           ; ----< Send 5th: Last File Data Block Use Count >----
                        
.IniFileBlockLastCount  dey                               ; make sure to send at least one byte
                        
.ChkFileBlockLastCount  cpy [BUF3 + PRGLINKCOUNT]         ; used byte count of the last PGM file data block
.GotFileBlockLast       bcs .SerCnt_GetReady              ; greater/equal - all data of last block handled
                        
.SetFileBlockLastNext   iny                               ; 
.GetFileBlockLastNext   lda [BUF3 + PRGLINK],y            ; get last pgm data block next byte
.OutFileBlockLastNext   jsr VC1541_DataByteSend           ; ----< Send 6th: Last File Data Block Single Bytes >----
                        
.ChkFileBlockLastNext   jmp .ChkFileBlockLastCount        ; check if all data bytes are read
; -------------------------------------------------------------------------------------------------------------- ;
; All data read completely
; -------------------------------------------------------------------------------------------------------------- ;
.SerCnt_GetReady        lda #$00                          ; 
.SerCnt_SetReady        sta SERCNT                        ; VIA1($1800) 1541 Data Port B -> drive code stopped - ready to send
                        
                        lda #WPSW_DIFF                    ; disk has changed
.SetFlag_DiskChange     sta WPSW                          ; flag: drive #0 - disk change indicator
                        
VC1541_FileDataSendX    jmp ENDCMD                        ; terminate a command
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_SeekSector     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_SeekSector       subroutine                        ; 
                        ldx #$00                          ; 
.SetFlag_Bump_Sync_Yes  stx BBLZ_FlagBumpSYNC             ; 
.SetFlag_Bump_Hdr_Yes   stx BBLZ_FlagBumpHDR              ; 
                        
.GetFlag_DiskChange     ldx WPSW                          ; flag: drive #0 - disk change indicator
.ChkFlag_DiskChange     beq VC1541_SeekHeader             ; WPSW_SAME - disk hasn't changed
                        
.GetFlag_DiskSame       lda #WPSW_SAME                    ; disk has not changed
.SetFlag_DiskSame       sta WPSW                          ; flag: drive #0 - disk change indicator
                        
.GetJobCode_Seek        lda #JOBCC_SEEK                   ; Seek a sector
VC1541_SeekSectorX      jsr VC1541_Exec_Job0              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_SeekHeader     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_SeekHeader       subroutine                        ; 
.NextJobCode_Exec       lda #JOBCC_EXECUTE                ; Exec program in buffer / switch drive on and position head
                        jsr VC1541_Exec_Job0              ; located in Buf0 --> VC1541_GoFindHdrBlock
                        
.ChkError_NotFound_Hdr  cmp #JOBST_ERR_NOHDR              ; 20, READ ERROR -> Header block not found
                        bne VC1541_SeekHeaderX            ; exit
                        
.GetFlag_Bump_Hdr       lda BBLZ_FlagBumpHDR              ; 
.ChkFlag_Bump_Hdr_No    bne VC1541_SeekHeaderX            ; BBLZ_FlagBump_No
                        
.SetFlag_Bump_Hdr_No    inc BBLZ_FlagBumpHDR              ; set BBLZ_FlagBump_No
                        
.GetJobCode_Bump_Hdr    lda #JOBCC_BUMP                   ; Bump head - find track $01
                        jsr VC1541_Exec_Job0              ; 
                        
.GetJobCode_Seek        lda #JOBCC_SEEK                   ; Seek a sector
                        jsr VC1541_Exec_Job0              ; 
                        
.ChkError_OK            cmp #JOBST_OK                     ; 00, OK -> Everything OK
                        bne VC1541_SeekHeaderX            ; no - exit
                        
.GoNextJobCode_Exec     jmp .NextJobCode_Exec             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.ChkError_NotFound_Sync cmp #JOBST_ERR_NOSYNC             ; 21, READ ERROR -> SYNC not found
                        bne VC1541_SeekHeaderX            ; exit
                        
.GetFlag_Bump_Sync      lda BBLZ_FlagBumpSYNC             ; normally: buffer #4 - sector
.ChkFlag_Bump_Sync_No   bne VC1541_SeekHeaderX            ; BBLZ_FlagBump_No
                        
.SetFlag_Bump_Sync_No   inc BBLZ_FlagBumpSYNC             ; set BBLZ_FlagBump_No
                        
.GetJobCode_Bump_02     lda #JOBCC_BUMP                   ; Bump head - find track 01
                        jsr VC1541_Exec_Job0              ; 
                        
                        jmp VC1541_SeekHeader             ; 
                        
VC1541_SeekHeaderX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; VC1541_Exec_Job0      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_Exec_Job0        subroutine                        ; 
                        sta LSTJOB0                       ; original disk controller commands of buf0
                        sta TEMPCMD                       ; temp area for disk controller command
                        sta JOBS                          ; command code
                        
.GetDisplayAll          lda #$ff                          ; 
.SetDisplayAll          sta JOBRTN                        ; flag: message display for disk errors
                        
                        ldx #$00                          ; 
                        
                        cli                               ; 
                        
.WaitForJobOK           jsr TSTJOB                        ; test if job has ended without errors
                        bcs .WaitForJobOK                 ; 
                        
VC1541_Exec_Job0X       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
VC1541_FileNameLen      equ *
VC1541_FileName         equ [* + $01]
                        dc.b $a5 ; lda $fd
                        dc.b $fd ; 		
                        dc.b $d0 ; bne $fbed
                        dc.b $03 ; 		
                        dc.b $4c ; jmp $f704
                        dc.b $04 ; 
                        dc.b $f7 ; 
                        dc.b $c9 ; cmp #$80
                        dc.b $80 ; 	  
                        dc.b $d0 ; bne $fbf4
                        dc.b $03 ; 		
                        dc.b $4c ; jmp $f707
                        dc.b $07 ; 
                        dc.b $f7 ; 
                        dc.b $4c ; jmp $f5a9
                        dc.b $a9 ; 
                        dc.b $f5 ; 
                        dc.b $49 ; eor #$01
                        dc.b $01 ; 
                        dc.b $a9 ; lda #$f5
                        dc.b $f5 ; 
                        dc.b $00 ; dc.b $00
                        dc.b $00 ; dc.b $00
                        dc.b $e7 ; dc.b $e7
                        dc.b $a0 ; ldy #$00
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rend                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_Kernal_Len     equ [* - CopyCode_Kernal]   ; 
; -------------------------------------------------------------------------------------------------------------- ;
C64_FileNameLen         = $fbe6
C64_FileName            = $fbe7
; -------------------------------------------------------------------------------------------------------------- ;
; End: code copied over to 1541 buffer $0300
; -------------------------------------------------------------------------------------------------------------- ;
